﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CD_Account_Test
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda GetCDData() akceptująca argument w postaci
        // obiektu CDAccount. Dane wprowadzone przez użytkownika
        // zostają przypisane właściwościom obiektu.
        private void GetCDData(CDAccount account)
        {
            // Zmienne tymczasowe przechowujące
            // wysokość stopy procentowej i saldo.
            decimal interestRate;
            decimal balance;

            // Pobranie numeru konta.
            account.AccountNumber = accountNumberTextBox.Text;

            // Pobranie daty wykupu.
            account.MaturityDate = maturityDateTextBox.Text;

            // Pobranie wysokości stopy procentowej.
            if (decimal.TryParse(interestRateTextBox.Text, out interestRate))
            {
                account.InterestRate = interestRate;

                // Pobranie salda.
                if (decimal.TryParse(balanceTextBox.Text, out balance))
                {
                    account.Balance = balance;
                }
                else
                {
                    // Wyświetlenie komunikatu błędu.
                    MessageBox.Show("Niepoprawne saldo.");
                }
            }
            else
            {
                // Wyświetlenie komunikatu błędu.
                MessageBox.Show("Niepoprawna wysokość stopy procentowej.");
            }
        }

        private void createObjectButton_Click(object sender, EventArgs e)
        {
            // Utworzenie obiektu typu CDAccount.
            CDAccount myAccount = new CDAccount();

            // Pobranie danych certyfikatu depozytowego.
            GetCDData(myAccount);

            // Wyświetlenie danych certyfikatu depozytowego.
            accountNumberLabel.Text = myAccount.AccountNumber;
            interestRateLabel.Text = myAccount.InterestRate.ToString("n2");
            balanceLabel.Text = myAccount.Balance.ToString("c");
            maturityDateLabel.Text = myAccount.MaturityDate;
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
